/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.console;

import com.ibm.hsc.cecdiscover.server.HSCCECDiscoveryMgr;
import com.ibm.hsc.cim.provider.pi.PIHscProviderConstants;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.ConsoleCmdMgr;
import com.ibm.hsc.fsp.FspConnListener;
import com.ibm.hsc.fsp.HWSvrSocket;
import com.ibm.hsc.fsp.cmdhelpers.FspCecInstCmds;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.objmgr.console.OmConnListener;
import com.ibm.hsc.objmgr.console.OmConsoleUpdater;
import com.ibm.hsc.objmgr.console.OmHostsInfo;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import com.ibm.hsc.rep.server.RxServer;
import java.io.FileInputStream;
import java.util.Properties;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbemcmd.cimom.CIMServer;
import org.snia.wbemcmd.cimom.PluginServices;

public class OmConsoleMgr
implements PluginServices {
    private static OmConsoleMgr mInst = null;
    public static int GettingIpAddrLparTimeoutInSec = 60;
    public static int NumOfHmcSupported = 1;
    public static UnsignedInt64 HmcConcMaintCaps = PIHscProviderConstants.IO_CONC_CAP_VALUE;
    public static int CecDiscoverCommandTimeoutInSec = 60;
    private CIMServer mCimServer = null;
    private HWSvrSocket mHWSvrSocket = null;
    private OmConsoleUpdater mConsoleUpdater = null;
    private ConsoleCmdMgr mCmdMgr = new ConsoleCmdMgr(this);
    private String mHmcId = null;
    private OmConnListener mConnListener = new OmConnListener(this);

    public static synchronized OmConsoleMgr getConsoleMgr() {
        if (mInst == null) {
            mInst = new OmConsoleMgr();
        }
        return mInst;
    }

    private OmConsoleMgr() {
        this.mHWSvrSocket = HWSvrSocket.createInstance(this.mConnListener);
        System.out.println("created console mgr");
    }

    public void init(CIMServer cIMServer) {
        System.out.println("calling init in consoleMgr");
        this.mCimServer = cIMServer;
        try {
            RxServer.start(6060, 5);
            System.out.println("started rep");
            if (this.mHmcId == null) {
                this.mHmcId = this.mHWSvrSocket.getHmcId();
            }
            System.out.println("got hmcid " + this.mHmcId);
            this.mConsoleUpdater = new OmConsoleUpdater(this);
            this.mConsoleUpdater.createConsoleInst();
            System.out.println("created console inst");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void reconnect() {
        this.mCmdMgr.reinitialize();
    }

    public String getHmcId() {
        return this.mHmcId;
    }

    public void hwSrvDisconnected(long l) {
    }

    public FspConnListener getFspListener() {
        return this.mConnListener;
    }

    public void cimomSocketIsReady() {
        System.out.println("calling cimomSocketIsReady");
        try {
            HSCEventIndicationMgr.getInstance();
            System.out.println("created indication server");
            this.mHWSvrSocket.initialize();
            System.out.println("initialized hardware server");
            HSCCECDiscoveryMgr.getInstance();
            System.out.println("starts HSCCECDiscoveryMgr");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public CIMServer getCimServer() {
        return this.mCimServer;
    }

    public boolean removeSys(String string, String string2, byte by) throws PIHscServerException {
        OmSysMgr omSysMgr = null;
        Object var5_5 = null;
        System.out.println("rm sys sysName = " + string);
        System.out.println("rm ipAddr = " + string2);
        System.out.println("rm type = " + by);
        if (string == null && string2 == null) {
            System.out.println("both ipAddr and SysName are null");
            throw new PIHscServerException("026F", null, null);
        }
        if (string2 != null && (omSysMgr = OmSysMgr.getSysMgrByIP(string2)) == null) {
            System.out.println("cannot find sysMgr by ip");
            throw new PIHscServerException("0269", new String[]{string2}, null);
        }
        if (omSysMgr != null && string != null && !string.equals(omSysMgr.getSysName())) {
            System.out.println("invalid sys name and ip comb " + omSysMgr.getSysName());
            throw new PIHscServerException("026A", null, null);
        }
        if (omSysMgr == null && string != null) {
            omSysMgr = OmSysMgr.getSysMgr(string);
        }
        if (omSysMgr == null) {
            System.out.println("cannot find sysMgr by name");
            throw new PIHscServerException("026B", new String[]{string}, null);
        }
        System.out.println("calling delete sys all");
        return omSysMgr.deleteSysAll(by, string2);
    }

    public void addSys(String string, String string2, int n) throws PIHscServerException {
        if (n == 1) {
            OmHostsInfo.createBpcIpInfo(string, null);
        }
        try {
            new FspCecInstCmds().addSysCmd(this.mCmdMgr, string, string2, n);
        }
        catch (Throwable throwable) {
            if (n == 1) {
                OmHostsInfo.deleteBpcIpInfo(string, null);
            }
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("026C", new String[]{string}, throwable);
        }
    }

    public void reboot() throws PIHscServerException {
        new FspCecInstCmds().tempDisconnAllFspsCmd(this.mCmdMgr);
    }

    static {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("/opt/hsc/data/hmc.properties"));
            String string = properties.getProperty("GettingIpAddrLparTimeoutInSec");
            System.out.println("GettingIpAddrLparTimeoutInSec is: " + string);
            if (string != null) {
                GettingIpAddrLparTimeoutInSec = Integer.parseInt(string);
            }
            string = properties.getProperty("NumOfHmcSupported");
            System.out.println("NumOfHmcSupported is: " + string);
            if (string != null) {
                NumOfHmcSupported = Integer.parseInt(string);
            }
            string = properties.getProperty("HmcConcMaintCaps");
            System.out.println("The HMC I/O conc maint capabilities are:  " + string);
            if (string != null) {
                HmcConcMaintCaps = new UnsignedInt64(string);
            }
            string = properties.getProperty("CecDiscoverCommandTimeoutInSec");
            System.out.println("CecDiscoverCommandTimeoutInSec is: " + string);
            if (string != null) {
                CecDiscoverCommandTimeoutInSec = Integer.parseInt(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

